#include <bits/stdc++.h>
#define ll long long

using namespace std;

#define MAXN 150005

ll N, K;
ll X[MAXN], V[MAXN];
double arr[MAXN];
double temp[MAXN];

ll merge(ll left, ll mid, ll right)
{
  ll i, j, k;
  ll c = 0;

  i = left;
  j = mid;
  k = left;
  while ((i <= mid - 1) && (j <= right))
  {
    if (arr[i] <= arr[j])
    {
      temp[k++] = arr[i++];
    }
    else
    {
      temp[k++] = arr[j++];

      c = c + (mid - i);
    }
  }

  while (i <= mid - 1)
    temp[k++] = arr[i++];

  while (j <= right)
    temp[k++] = arr[j++];

  for (i = left; i <= right; i++)
    arr[i] = temp[i];

  return c;
}

ll mergeSort(ll left, ll right)
{
  ll mid;
  ll c = 0;
  if (right > left)
  {
    mid = (right + left) / 2;

    c += mergeSort(left, mid);
    c += mergeSort(mid + 1, right);

    c += merge(left, mid + 1, right);
  }
  return c;
}

int main()
{
  ios_base::sync_with_stdio(0);
  cin.tie(0);

  cin >> N >> K;

  for (ll i = 0; i < N; i++)
  {
    cin >> X[i] >> V[i];
  }

  if (N == 2)
  {
    double t = (double)(X[1] - X[0]) / (V[0] - V[1]);
    cout << fixed << setprecision(9) << t << endl;
    return 0;
  }

  double l = 0, r = 1e18;
  while (r - l > 1e-9)
  {
    double m = (l + r) / 2;
    for (ll i = 0; i < N; i++)
    {
      arr[i] = X[i] + m * V[i];
    }
    ll c = mergeSort(0, N - 1);

    if (c >= K)
      r = m;
    else
      l = m + 1e-9;
  }

  cout << fixed << setprecision(9) << l << endl;

  return 0;
}